TFCSystem_GlobalData = {}

local function onInitGlobalModData(isNewGame)
    local modData = ModData.getOrCreate("tubFluidContainerSystem")
    if not modData.Registered then modData.Registered = {} end
    modData.Activated = {}
    modData.PendedRemove = modData.PendedRemove or {}
    TFCSystem_GlobalData = modData
end

local function onReceiveGlobalModData(key, data)
    if not isClient() then return end
    if key and key == "tubFluidContainerSystem" then
        TFCSystem_GlobalData = data
    end
end

function TFCSystemTransmit()
    ModData.transmit("tubFluidContainerSystem")
end

function GetTFCSystemData()
    -- if isClient() then
    --     return ModData.request("tubFluidContainerSystem")
    -- end
    return TFCSystem_GlobalData
end

function ClearTFCSystemData()
    TFCSystem_GlobalData = {}
end


Events.OnInitGlobalModData.Add(onInitGlobalModData)
Events.OnReceiveGlobalModData.Add(onReceiveGlobalModData)
